from sklearn.neural_network import MLPClassifier
from sklearn.model_selection import train_test_split
from sklearn.datasets import make_classification
from sklearn.metrics import accuracy_score
import joblib

# Générer un jeu de données d'exemple
X, y = make_classification(n_samples=1000, n_features=20, random_state=42)

# Diviser les données en ensembles d'entraînement et de test
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)

# Créer un classifieur de réseau de neurones
mlp = MLPClassifier(hidden_layer_sizes=(10,), max_iter=1000, random_state=42)

# Entraîner le modèle
mlp.fit(X_train, y_train)

# Faire des prédictions
y_pred = mlp.predict(X_test)

# Évaluer la précision du modèle
accuracy = accuracy_score(y_test, y_pred)
print(f"Précision du modèle : {accuracy:.2f}")

# Sauvegarder le modèle dans un fichier
model_filename = 'classifier_model.joblib'
joblib.dump(mlp, model_filename)
print(f"Modèle sauvegardé dans {model_filename}")

dataset_filename = 'classifier_test_dataest.joblib'
joblib.dump(X_test, dataset_filename)
print(f"Jeu de test sauvegardé dans {dataset_filename}")
