#!/usr/bin/env python3
import sys
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.dates as md
import dateutil
from collections import OrderedDict

# Vérifie si un argument a été passé
if len(sys.argv) != 2:
    print("Usage: ./plot_alumet_rapl.py <chemin_vers_fichier_csv>")
    sys.exit(1)

# Lit le chemin du fichier CSV depuis le premier argument
file_path = sys.argv[1]

# Lit les données CSV
df = pd.read_csv(file_path, delimiter=';')
df['timestamp'] = [dateutil.parser.parse(s) for s in df['timestamp']]

# Calcul des totaux
for key, group in df.groupby(['resource_id', 'domain']):
    cpu_id = int(key[0])
    rapl_domain = key[1]
    total_energy = sum(group['value'])
    print(f"Total énergie consommée sur cpu{cpu_id}_{rapl_domain} = {total_energy:.2f} J")

# Trace la courbe
plt.figure(figsize=(10, 6))
for key, group in df.groupby(['resource_id', 'domain']):
    cpu_id = int(key[0])
    rapl_domain = key[1]
    plt.plot(group['timestamp'], group['value'], label=f"cpu{cpu_id}_{rapl_domain}")

# Ajoute des labels et une légende
plt.xlabel('Temps')
plt.ylabel('Énergie (Joules)')
plt.title("Consommation d'énergie rapportée par RAPL")

handles, labels = plt.gca().get_legend_handles_labels()
by_label = OrderedDict(zip(labels, handles))
# print(by_label)
plt.legend(by_label.values(), by_label.keys())

# format date
ax=plt.gca()
xfmt = md.DateFormatter('%H:%M:%S.%f')
ax.xaxis.set_major_formatter(xfmt)

# layout
plt.xticks(rotation=45)
plt.tight_layout()

# Affiche le graphe
plt.show()
